﻿  package{
	  import flash.display.*;
	  import flash.text.*;
	  import flash.events.*;
	  import flash.net.*;
	  import flash.geom.Rectangle;
	  
	  public class ScrollBar extends Sprite{		  
	  	  public var dispatcher:EventDispatcher = new EventDispatcher();
		  public var flagDisabled = false;
		  public var minBarHeight = 35;
		  public var baseBarHeight:Number = -1;
		  public var flagDragging = false;
		  public var barPosPercent = 0;
		  public var flagStageLoaded:Boolean = false;
		  
		  //inline items:
		  //mc_bar
		  // mc_line
		  
		  //constructor
		  public function ScrollBar(){
			  mc_bar.buttonMode = true;
			  mc_bar.addEventListener(MouseEvent.MOUSE_DOWN,barMousedownHandler);
			  this.baseBarHeight = mc_bar.height;			  
		  }
		  
		//--------------------------------------------------------------------------------		
		//check stage event add. add them only once.
		public function checkStageEvent(){
			if(this.flagStageLoaded == false && this.stage != null){
				this.stage.addEventListener(MouseEvent.MOUSE_UP, stageMouseupHandler);
				this.stage.addEventListener(MouseEvent.MOUSE_MOVE, stageMousemoveHandler);
				this.flagStageLoaded = true;
			}			
		}
		  		  
		  //------------------------------------------------------------
		  //stop dragging the bar.
		  function stageMouseupHandler(event:MouseEvent){
			  mc_bar.stopDrag();
			  this.flagDragging = false;
		  }
		  
		  //------------------------------------------------------------
		  // start dragging the bar
		  private function barMousedownHandler(event:MouseEvent){
			  if(isDisabled() == true) return(false);	//can't move disabled bar
			  
			  var rect:Rectangle = new Rectangle(mc_bar.x,mc_line.y,0,mc_line.height-mc_bar.height);
			  mc_bar.startDrag(false,rect);
			  this.flagDragging = true;
		  }
		  
		  //------------------------------------------------------------
		  // update percent for the parent uses
		  public function updateBarPercent(){
				this.barPosPercent = Math.floor(mc_bar.y) / Math.floor((mc_line.height-mc_bar.height));  
		  }
		  
		  //------------------------------------------------------------
		  // if is dragging - update pos percent
		  private function stageMousemoveHandler(event:MouseEvent){
			  if(this.flagDragging == true){
				  updateBarPercent();
				  this.dispatcher.dispatchEvent(new Event("scrollBarMoving"));
			  }
		  }
		  
		  //------------------------------------------------------------
		  
		  public function setHeight(height){
			  mc_line.height = height;
		  }
		  		  
		  //------------------------------------------------------------
		  //update the position and the size of the bar
		  public function update(heightFull:Number,posyFull:Number,heightPart:Number,posyPart:Number){
			  checkStageEvent();
			  if(heightFull <= heightPart){
				  mc_bar.y = mc_line.y;
				  resetBar();
				  disable();
				  return(false);
			  }
			  enable();
			  
			  //set bar height:
			  var barHeight:Number = heightPart / heightFull * mc_line.height;
			  if(barHeight < minBarHeight) barHeight = this.minBarHeight;
			  mc_bar.height = barHeight;
			  
			  //fit the scrollbar to the line
			  if((mc_bar.y + mc_bar.height) > mc_line.height) mc_bar.y = mc_line.height-mc_bar.height;
		  }
		  
		  //------------------------------------------------------------
		  // set bar height to minimum and move to top
		  public function resetBar(){
			  checkStageEvent();
			  mc_bar.y = mc_line.y;
			  mc_bar.height = this.baseBarHeight;
		  }
		  
		  //------------------------------------------------------------
		  // return if the items are disabled or not
		  public function isDisabled(){
			  return(this.flagDisabled);
		  }
		  
		  //------------------------------------------------------------
		  // move the bar up or down.
		  public function moveBar(points:Number,dir:String){
			  if(this.flagDisabled == true) return(false);	 //can't move disabled scrollbar
			  
			  var nowY:Number;
			  var maxY:Number;
			  var minY:Number;
			  var newY:Number;
			  
			  if(dir.toLowerCase() == "down"){
				  nowY = mc_bar.y;
			  	  maxY = mc_line.height - mc_bar.height;
				  if(maxY == nowY) return(false);
				  
				  newY = nowY + points;
				  if(newY>maxY) newY = maxY;
				  
				  mc_bar.y = newY;
				  updateBarPercent();
			  }
			  else{
				  nowY = mc_bar.y;
				  minY = 0;
				  if(maxY == nowY) return(false);
				  
				  newY = nowY - points;
				  if(newY < minY) newY = minY;				  				  
				  
				  mc_bar.y = newY;
				  updateBarPercent();
			  }
		  }
		  
		  //------------------------------------------------------------
		  
		  public function disable(){
			  this.flagDisabled = true;
			  mc_bar.alpha = 0.1;
			  mc_line.alpha = 0.1;
			  
		  }
		  
		  //------------------------------------------------------------
		  
		  public function enable(){
			  this.flagDisabled = false;
			  mc_bar.alpha = 1;
			  mc_line.alpha = 1;
		  }
		  
		  //------------------------------------------------------------
		  // get position percent
		  public function getPosPercent(){
			  return(this.barPosPercent);
		  }
		  
	  }   
	  
  }